/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2005 by Myricom, Inc.  All rights reserved.                 *
 *************************************************************************/

#define MX_RAW_BYTES MX_MCP_RAW_MTU
#define MX_RAW_MAXROUTE MX_MCP_ROUTE_MAX_LENGTH
#define MX_RAW_NUM_RX_BUFS ((MX_MCP_RAW_RECV_VPAGES * MX_VPAGE_SIZE) / MX_RAW_BYTES)

void mx_kraw_rx_intr(mx_instance_state_t *is, uint32_t data0, uint32_t data1);
void mx_kraw_tx_intr(mx_instance_state_t *is, uint32_t data0, uint32_t data1);
void mx_kraw_tick(mx_instance_state_t *is);
int  mx_kraw_next_event(mx_endpt_state_t *es,  mx_raw_next_event_t *e);
int  mx_kraw_send(mx_endpt_state_t *es, mx_raw_send_t *s);
int  mx_kraw_set_route_begin(mx_endpt_state_t *es);
int  mx_kraw_set_route_end(mx_endpt_state_t *es);
int  mx_kraw_set_route(mx_endpt_state_t *es, mx_set_route_t *r, int clear);
int  mx_kraw_tick_change(mx_instance_state_t *is, int enable);
int  mx_kraw_init(mx_instance_state_t *is);
void mx_kraw_destroy(mx_instance_state_t *is);
